provider "aws" {
  region  = "us-west-2"
  profile = "twitch-aws"
}

provider "aws" {
  region  = "us-west-2"
  profile = "twitch-aws"
  alias   = "dns"
}

provider "aws" {
  region  = "us-west-2"
  profile = "twitch-web-dev"
  alias   = "uw2"

}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-dev/"
}

variable "aws_account" {
  default = "twitch-web-dev"
}

variable "environment" {
  default = "development"
}

variable "internal_zone_id" {
  default = "ZRG00SM48517Z"
}

variable "maintenance_window" {
  default = "thu:00:00-thu:00:30"
}
variable "monitoring_interval" {
  default = "60"
}

resource "aws_security_group" "pass-db-sg" {
  description = "security rules for the testing rds password"
  name = "pass-db-${var.environment}"
  provider = "aws.uw2"
  vpc_id = "${module.common.vpc_id}"

  egress {
    from_port = 0
    to_port = 0
    protocol = -1
    cidr_blocks = ["0.0.0.0/0"]
  }
  ingress {
    from_port = 5432
    to_port = 5432
    protocol = "tcp"
    cidr_blocks = ["10.0.0.0/8","192.168.0.0/16","192.16.64.0/21"]
  }
  tags {
    Name = "test-pass-${var.environment}/security"
    Owner = "d8a <d8a@justin.tv>"
    Project = "d8a/experiments"
  }
}

resource "aws_db_instance" "pass-master" {
  allocated_storage = "500"
  auto_minor_version_upgrade = "true"
  backup_retention_period = "14"
  backup_window = "10:24-10:54"
  copy_tags_to_snapshot = "true"
  db_subnet_group_name = "d8a-subnet-group"
  engine = "postgres"
  engine_version = "9.5.6"
  identifier = "password-test-master"
  instance_class = "db.t2.small"
  monitoring_interval = "${var.monitoring_interval}"
  monitoring_role_arn = "arn:aws:iam::465369119046:role/rds-monitoring-role"
  maintenance_window = "${var.maintenance_window}"
  multi_az = "false"
  name = "passtest"
  provider = "aws.uw2"
  skip_final_snapshot = "true"
  storage_type = "gp2"
  vpc_security_group_ids = ["${aws_security_group.pass-db-sg.id}"]

  username = "pg"
  password = "whatever"

  tags {
    Environment = "${var.environment}"
    Name = "password-rds-test"
    Owner = "abrashears@twitch.tv"
    Project = "d8a-r-n-d"
  }
}

resource "aws_route53_record" "pass-master-cname" {
  provider = "aws.dns"
  zone_id = "ZRG00SM48517Z"
  name = "${aws_db_instance.pass-master.identifier}.${var.environment}.${var.aws_account}"
  type = "CNAME"
  ttl = "60"
  records = ["${aws_db_instance.pass-master.address}"]
}
