variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
  alias = "twitch-chat-aws"

}

##
# Data Engineering Instance Profile
##

resource "aws_iam_instance_profile" "postgres" {
    provider = "aws.twitch-chat-aws"
    name = "chat-postgres"
    roles = ["${aws_iam_role.postgres.name}"]
}

##
# Data Engineering Roles
##

resource "aws_iam_role" "postgres" {
    name = "chat-postgres"
    provider = "aws.twitch-chat-aws"
    assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "chat_postgres_staging" {
    provider = "aws.twitch-chat-aws"
    name = "chat_postgres_staging"
    roles = ["${aws_iam_role.chat_postgres_staging.name}"]
}


resource "aws_iam_role" "chat_postgres_staging" {
  name = "chat_postgres_staging"
  provider = "aws.twitch-chat-aws"
  assume_role_policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
      {
        "Action": "sts:AssumeRole",
        "Principal": {
          "Service": "ec2.amazonaws.com"
        },
        "Effect": "Allow",
        "Sid": ""
      }
    ]
}
EOF
}


##
# Attach inline-IAM policy
##

# prod policy
resource "aws_iam_role_policy" "chat-pg-policy" {
    name = "chat-pg-policy"
    role = "${aws_iam_role.postgres.id}"
    provider = "aws.twitch-chat-aws"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "cloudwatch:*",
                "autoscaling:Describe",
                "logs:*",
                "sns:*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": [
                "s3:Get*",
                "s3:Put*",
                "s3:List*",
                "s3:DeleteObject"
            ],
            "Resource": [
                "arn:aws:s3:::science-input*",
                "arn:aws:s3:::science-input/*",
                "arn:aws:s3:::d8a-chat-backup*",
                "arn:aws:s3:::d8a-chat-backup/*",
                "arn:aws:s3:::science-input/dbsnapshots*",
                "arn:aws:s3:::science-input/dbsnapshots/*"
            ]
        },
        {
            "Effect": "Deny",
            "Action": [
                "cloudwatch:Delete*",
                "logs:Delete*",
                "sns:Delete*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": "sts:AssumeRole",
            "Resource": [
            "arn:aws:iam::734326455073:role/sandstorm-agent-data-eng",
            "arn:aws:iam::673385534282:role/clio",
            "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/postgres_tmi_production",
            "arn:aws:iam::673385534282:role/Clio_PHC_Analytics",
            "arn:aws:iam::673385534282:role/d8a-dbsnapshots"
            ]
        }
    ]
}
EOF
}

# don't want staging role to access s3
resource "aws_iam_role_policy" "chat_postgres_staging_policy" {
    name = "chat_postgres_staging_policy"
    role = "${aws_iam_role.chat_postgres_staging.id}"
    provider = "aws.twitch-chat-aws"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "cloudwatch:*",
                "autoscaling:Describe",
                "logs:*",
                "sns:*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": [
                "s3:Get*",
                "s3:Put*",
                "s3:List*",
                "s3:DeleteObject"
            ],
            "Resource": [
                "arn:aws:s3:::science-input*",
                "arn:aws:s3:::science-input/*",
                "arn:aws:s3:::d8a-chat-backup*",
                "arn:aws:s3:::d8a-chat-backup/*",
                "arn:aws:s3:::twitch-d8a-test*",
                "arn:aws:s3:::twitch-d8a-test/*"
            ]
        },
        {
            "Effect": "Deny",
            "Action": [
                "cloudwatch:Delete*",
                "logs:Delete*",
                "sns:Delete*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": "sts:AssumeRole",
            "Resource": [
                "arn:aws:iam::734326455073:role/sandstorm-agent-data-eng",
                "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/postgres_tmi_staging",
                "arn:aws:iam::673385534282:role/Clio_PHC_Analytics"
            ]
        }
    ]
}
EOF
}
