variable "twitch_video_aws_access_key" {}
variable "twitch_video_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_video_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_video_aws_secret_key}"
  alias = "twitch-aws"
}

##
# Postgres networkdb Instance Profile
##

resource "aws_iam_instance_profile" "networkdb-postgres" {
    provider = "aws.twitch-aws"
    name = "networkdb-postgres"
    roles = ["${aws_iam_role.networkdb-postgres.name}"]
}

##
# Postgres networkdb Roles
##

resource "aws_iam_role" "networkdb-postgres" {
    name = "networkdb-postgres"
    provider = "aws.twitch-aws"
    assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

##
# Attach inline-IAM policy
##

resource "aws_iam_role_policy" "d8a_pg_policy" {
    name = "networkdb-postgres"
    role = "${aws_iam_role.networkdb-postgres.id}"
    provider = "aws.twitch-aws"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "cloudwatch:*",
                "autoscaling:Describe",
                "logs:*",
                "sns:*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Deny",
            "Action": [
                "cloudwatch:Delete*",
                "logs:Delete*",
                "sns:Delete*"
            ],
            "Resource": "*"
        },
        {
          "Action": "sts:AssumeRole",
          "Resource": [
            "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/postgres_network_staging"
          ],
          "Effect": "Allow"
        }
    ]
}
EOF
}

