##
# Datadev Instance Profile
##

resource "aws_iam_instance_profile" "datadev" {
    name = "datadev"
    role = "${aws_iam_role.datadev.name}"
}

##
# Datadev Role
##

resource "aws_iam_role" "datadev" {
    name = "datadev"
    assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

##
# Attach inline-IAM policy
##

resource "aws_iam_role_policy" "datadev_pg_policy" {
    name = "datadev"
    role = "${aws_iam_role.datadev.id}"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "cloudwatch:*",
                "autoscaling:Describe",
                "logs:*",
                "sns:*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": [
                "s3:PutObject",
                "s3:PutObjectAcl",
                "s3:GetObject",
                "s3:ListObjects",
                "sqs:SendMessage",
                "sqs:ReceiveMessage",
                "sqs:DeleteMessage"
            ],
            "Resource": [
                "arn:aws:s3:::d8a/clio/*",
                "arn:aws:sqs:us-west-2:673385534282:Clio_Pull_Request",
                "arn:aws:sqs:us-west-2:673385534282:Clio_RDS_Update",
                "arn:aws:s3:::clio-webhost/*"
            ]
        },
        {
            "Effect": "Deny",
            "Action": [
                "cloudwatch:Delete*",
                "logs:Delete*",
                "sns:Delete*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": [
                "sts:AssumeRole"
            ],
            "Resource": [
                "arn:aws:iam::673385534282:role/Clio_PHC_Analytics",
                "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/clio"
            ]

        }
    ]
}
EOF
}
