provider "aws" {
  region = "us-west-2"
  profile = "twitch-web-aws"
}

##
# Postgres/Sitedb User Needed because of SFO boxes, will have a policy that does not allow Put to S3
##
resource "aws_iam_user" "postgres" {
    name = "postgres"
}

resource "aws_iam_user_policy" "postgres" {
    name = "postgres"
    user = "${aws_iam_user.postgres.name}"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "cloudwatch:*",
                "autoscaling:Describe",
                "logs:*",
                "sns:*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": [
                "s3:Get*",
                "s3:List*",
                "s3:DeleteObject"
            ],
            "Resource": [
                "arn:aws:s3:::science-input*",
                "arn:aws:s3:::science-input/*",
                "arn:aws:s3:::d8a-web-backup*",
                "arn:aws:s3:::d8a-web-backup/*",
                "arn:aws:s3:::twitch-web-dev*",
                "arn:aws:s3:::twitch-web-dev/*",
                "arn:aws:s3:::postgres-schema-backup*",
                "arn:aws:s3:::postgres-schema-backup/*",
                "arn:aws:s3:::postgres-deprecated-relations*",
                "arn:aws:s3:::postgres-deprecated-relations/*"
            ]
        },
        {
            "Effect": "Deny",
            "Action": [
                "cloudwatch:Delete*",
                "logs:Delete*",
                "sns:Delete*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": "sts:AssumeRole",
            "Resource": [
                "arn:aws:iam::734326455073:role/sandstorm-agent-data-eng",
                "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/postgres_production",
                "arn:aws:iam::673385534282:role/Clio_PHC_Analytics"
                ]
        }
    ]
}
EOF
}


##
# Postgres/Sitedb Instance Profile
##

resource "aws_iam_instance_profile" "postgres" {
    name = "postgres"
    role = "${aws_iam_role.postgres.name}"
}

##
# Postgres/Sitedb Roles
##

resource "aws_iam_role" "postgres" {
    name = "postgres"
    assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "postgres_discovery_prod" {
    name = "postgres_discovery_prod"
    role = "${aws_iam_role.postgres_discovery_prod.name}"
}


resource "aws_iam_role" "postgres_discovery_prod" {
  name = "postgres_discovery_prod"
  assume_role_policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
      {
        "Action": "sts:AssumeRole",
        "Principal": {
          "Service": "ec2.amazonaws.com"
        },
        "Effect": "Allow",
        "Sid": ""
      }
    ]
}
EOF
}
##
# Attach inline-IAM policy
##

resource "aws_iam_role_policy" "d8a_pg_policy" {
    name = "postgres"
    role = "${aws_iam_role.postgres.id}"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "cloudwatch:*",
                "autoscaling:Describe",
                "logs:*",
                "sns:*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": [
                "s3:Get*",
                "s3:Put*",
                "s3:List*",
                "s3:DeleteObject"
            ],
            "Resource": [
                "arn:aws:s3:::science-input*",
                "arn:aws:s3:::science-input/*",
                "arn:aws:s3:::d8a-web-backup*",
                "arn:aws:s3:::d8a-web-backup/*",
                "arn:aws:s3:::twitch-web-dev*",
                "arn:aws:s3:::twitch-web-dev/*"
            ]
        },
        {
            "Effect": "Deny",
            "Action": [
                "cloudwatch:Delete*",
                "logs:Delete*",
                "sns:Delete*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": "sts:AssumeRole",
            "Resource": [
                "arn:aws:iam::734326455073:role/sandstorm-agent-data-eng",
                "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/postgres_production",
                "arn:aws:iam::673385534282:role/Clio_PHC_Analytics",
                "arn:aws:iam::066620209965:role/AmazonS3TwitchEmailWriteOnly"
              ]
        }
    ]
}
EOF
}



resource "aws_iam_role_policy" "discovery_postgres_policy" {
    name = "discovery_postgres_policy"
    role = "${aws_iam_role.postgres_discovery_prod.id}"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "cloudwatch:*",
                "autoscaling:Describe",
                "logs:*",
                "sns:*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": [
                "s3:Get*",
                "s3:Put*",
                "s3:List*",
                "s3:DeleteObject"
            ],
            "Resource": [
                "arn:aws:s3:::science-input*",
                "arn:aws:s3:::science-input/*",
                "arn:aws:s3:::d8a-web-backup*",
                "arn:aws:s3:::d8a-web-backup/*",
                "arn:aws:s3:::twitch-web-dev*",
                "arn:aws:s3:::twitch-web-dev/*"
            ]
        },
        {
            "Effect": "Deny",
            "Action": [
                "cloudwatch:Delete*",
                "logs:Delete*",
                "sns:Delete*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": "sts:AssumeRole",
            "Resource": [
                "arn:aws:iam::734326455073:role/sandstorm-agent-data-eng",
                "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/postgres_discovery_production",
                "arn:aws:iam::673385534282:role/Clio_PHC_Analytics"
            ]
        }
    ]
}
EOF
}
