terraform {
  required_version = "0.11.7"
}
provider "aws" {
  region = "us-west-2"
  profile = "twitch-web-dev"
}

##
# Data Engineering Instance Profile
##

resource "aws_iam_instance_profile" "postgres" {
    provider = "aws"
    name = "postgres"
    role = "${aws_iam_role.postgres.name}"
}

##
# Data Engineering Roles
##

resource "aws_iam_role" "postgres" {
    name = "postgres"
    provider = "aws"
    assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "postgres_discovery_dev" {
    provider = "aws"
    name = "postgres_discovery_dev"
    role = "${aws_iam_role.postgres_discovery_dev.name}"
}


resource "aws_iam_role" "postgres_discovery_dev" {
  name = "postgres_discovery_dev"
  provider = "aws"
  assume_role_policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
      {
        "Action": "sts:AssumeRole",
        "Principal": {
          "Service": "ec2.amazonaws.com"
        },
        "Effect": "Allow",
        "Sid": ""
      }
    ]
}
EOF
}


##
# Attach inline-IAM policy
##

resource "aws_iam_role_policy" "d8a_pg_policy" {
    name = "postgres"
    role = "${aws_iam_role.postgres.id}"
    provider = "aws"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "cloudwatch:*",
                "autoscaling:Describe",
                "logs:*",
                "sns:*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": [
                "s3:Get*",
                "s3:Put*",
                "s3:List*",
                "s3:DeleteObject"
            ],
            "Resource": [
                "arn:aws:s3:::science-input*",
                "arn:aws:s3:::science-input/*",
                "arn:aws:s3:::twitch-web-dev*",
                "arn:aws:s3:::twitch-web-dev/*",
                "arn:aws:s3:::twitch-d8a-test*",
                "arn:aws:s3:::twitch-d8a-test/*",
                "arn:aws:s3:::postgres-deprecated-relations*",
                "arn:aws:s3:::postgres-deprecated-relations/*"
            ]
        },
        {
            "Effect": "Allow",
            "Action": [
                "s3:Get*",
                "s3:List*",
                "s3:DeleteObject"
            ],
            "Resource": [
                "arn:aws:s3:::d8a-web-backup*",
                "arn:aws:s3:::d8a-web-backup/*"
            ]
        },
        {
            "Effect": "Deny",
            "Action": [
                "cloudwatch:Delete*",
                "logs:Delete*",
                "sns:Delete*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": "sts:AssumeRole",
            "Resource": [
            "arn:aws:iam::734326455073:role/sandstorm-agent-data-eng",
            "arn:aws:iam::673385534282:role/clio",
            "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/staging_postgres",
            "arn:aws:iam::673385534282:role/Clio_PHC_Analytics",
            "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/data-eng-justintv_slony_master-development"
            ]
        }
    ]
}
EOF
}


resource "aws_iam_role_policy" "discovery_postgres_policy" {
    name = "discovery_postgres_policy"
    role = "${aws_iam_role.postgres_discovery_dev.id}"
    provider = "aws"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "cloudwatch:*",
                "autoscaling:Describe",
                "logs:*",
                "sns:*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": [
                "s3:Get*",
                "s3:Put*",
                "s3:List*",
                "s3:DeleteObject"
            ],
            "Resource": [
                "arn:aws:s3:::science-input*",
                "arn:aws:s3:::science-input/*",
                "arn:aws:s3:::twitch-web-dev*",
                "arn:aws:s3:::twitch-web-dev/*"
            ]
        },
        {
            "Effect": "Allow",
            "Action": [
                "s3:Get*",
                "s3:Put*",
                "s3:List*",
                "s3:DeleteObject"
            ],
            "Resource": [
                "arn:aws:s3:::d8a-web-backup*",
                "arn:aws:s3:::d8a-web-backup/*",
                "arn:aws:s3:::twitch-d8a-test*",
                "arn:aws:s3:::twitch-d8a-test/*"
            ]
        },
        {
            "Effect": "Deny",
            "Action": [
                "cloudwatch:Delete*",
                "logs:Delete*",
                "sns:Delete*"
            ],
            "Resource": "*"
        },
        {
            "Effect": "Allow",
            "Action": "sts:AssumeRole",
            "Resource": [
                "arn:aws:iam::734326455073:role/sandstorm-agent-data-eng",
                "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/postgres_discovery_staging",
                "arn:aws:iam::673385534282:role/Clio_PHC_Analytics"
            ]
        }
    ]
}
EOF
}
