
variable "vpc_id"{
  description = "vpc-230f5e46"
}

variable "vpc_cidr"{
    description = "10.194.0.0/18"
}

variable "twitch_private_subnets"{
    description = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16"
}

variable "data_a_cidr"{
    description = "10.194.12.0/24"
}

variable "data_b_cidr"{
  description = "10.194.28.0/24"

}

variable "data_c_cidr"{
    description = "10.194.44.0/24"
}

variable "twitch_vpn" {
    default = "10.255.244.0/22"
}

variable "cluster"{
    description = ""
}

variable "sg_environment"{
    description = "dev or prod"
}

variable "sfo_region_master"{
    default = "10.1.14.251/32"
}


####################################
#       SITEDB SG                  #
####################################

resource "aws_security_group" "db_sec" {
  description = "security rules for the production aws sitedb read replicas"
  name = "${var.cluster}_${var.sg_environment}"
  vpc_id = "${var.vpc_id}"

  egress {
    from_port = 0
    to_port = 0
    protocol = -1
    cidr_blocks = ["0.0.0.0/0"]
  }
  ingress {
    from_port = 22
    to_port = 22
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }
  # I am told that consul needs tcp and udp on 8306
  ingress {
    from_port = 8306
    to_port = 8306
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }
  ingress {
    from_port = 8306
    to_port = 8306
    protocol = "udp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }
  #10.194.236.9/32 is the backup host.
  ingress {
    from_port = 5432
    to_port = 5432
    protocol = "tcp"
    cidr_blocks = ["${var.data_a_cidr}", "${var.data_b_cidr}", "${var.data_c_cidr}", "${var.sfo_region_master}", "10.1.110.249/32", "10.194.236.9/32", "10.23.16.208/32"]
  }
  ingress {
    from_port = 6542
    to_port = 6545
    protocol = "tcp"
    cidr_blocks = ["10.0.0.0/8"]
  }
  ingress {
    from_port = 5666
    to_port = 5666
    protocol = "tcp"
    cidr_blocks = ["10.0.0.0/8"]
  }
  ingress {
    from_port = 12005
    to_port = 12006
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.vpc_cidr)}",
      "10.193.192.0/21", "10.193.208.0/21", "10.193.224.0/21", "10.192.192.0/18", # mystery CIDRs
      "10.201.36.0/24", "10.201.37.0/24", "10.201.38.0/24", # payments-service
      "10.193.8.0/22", "10.193.4.0/22","10.193.0.0/22", # video (channel_properties)
      "10.202.52.0/22", # subs (twitch-hats-aws)
      "10.201.96.0/22", # subs (twitch-mako-prod)
      "10.201.228.0/22", # roster (twitch-cb-aws)
    ]
  }
  ingress {
    from_port = 2015
    to_port = 2015
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }
  tags {
    Name = "rails-${var.sg_environment}-postgres/security"
    Owner = "d8a <d8a@justin.tv>"
    Project = "web/rails-postgres"
  }
}

output "db_sec_id" {
  value = "${aws_security_group.db_sec.id}"
}
