variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "vpc_id"{
  description = "vpc-230f5e46"
}

variable "twitch_private_subnets"{
    description = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16"
}

variable "data_a_cidr"{
    description = "10.194.12.0/24"
}

variable "data_b_cidr"{
  description = "10.194.28.0/24"

}

variable "data_c_cidr"{
    description = "10.194.44.0/24"
}

variable "sg_environment"{
    description = "sg_environment"
}


####################################
#           ZK SG                  #
####################################

resource "aws_security_group" "zk_sec" {
  description = "security rules for the production aws web zookeeper"
  name = "zk_${var.sg_environment}_security_00"
  vpc_id = "${var.vpc_id}"

  egress {
    from_port = 0
    to_port = 0
    protocol = -1
    cidr_blocks = ["0.0.0.0/0"]
  }

  ingress {
    from_port = 22
    to_port = 22
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }

  ingress {
    from_port = 8306
    to_port = 8306
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }

  # exhibitor port
  ingress {
    from_port = 8080
    to_port = 8080
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }

  # consul check port
  ingress {
    from_port = 8000
    to_port = 8000
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }

  # zk client connection port
  ingress {
    from_port = 2181
    to_port = 2181
    protocol = "tcp"
    cidr_blocks = ["${var.data_a_cidr}", "${var.data_b_cidr}", "${var.data_c_cidr}"]
  }

  # peer communication port
  ingress {
    from_port = 2888
    to_port = 2888
    protocol = "tcp"
    cidr_blocks = ["${var.data_a_cidr}", "${var.data_b_cidr}", "${var.data_c_cidr}"]
  }

  # leader election port
  ingress {
    from_port = 3888
    to_port = 3888
    protocol = "tcp"
    cidr_blocks = ["${var.data_a_cidr}", "${var.data_b_cidr}", "${var.data_c_cidr}"]
  }

  tags {
    Name = "zk-${var.sg_environment}/security"
    Owner = "d8a <d8a@justin.tv>"
    Project = "web/zk-cluster"
  }
}

output "zk_sec_id" {
  value = "${aws_security_group.zk_sec.id}"
}
