
variable "vpc_id"{
  description = "vpc-230f5e46"
}

variable "vpc_cidr"{
    description = "10.194.0.0/18"
}

variable "twitch_private_subnets"{
    description = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16,192.16.64.0/21"
}

variable "data_a_cidr"{
    description = "10.194.12.0/24"
}

variable "data_b_cidr"{
  description = "10.194.28.0/24"

}

variable "data_c_cidr"{
    description = "10.194.44.0/24"
}

variable "twitch_vpn" {
    default = "10.255.244.0/22"
}

variable "cluster"{
    description = ""
}

variable "haproxy_port_low" {
  default = "12005"
}

variable "haproxy_port_high" {
  default = "12005"
}

variable "sg_environment"{
    description = "dev or prod"
}


####################################
#       SITEDB SG                  #
####################################

resource "aws_security_group" "db_sec" {
  description = "security rules for the production aws sitedb read replicas"
  name = "${var.cluster}_${var.sg_environment}"
  vpc_id = "${var.vpc_id}"

  egress {
    from_port = 0
    to_port = 0
    protocol = -1
    cidr_blocks = ["0.0.0.0/0"]
  }
  ingress {
    from_port = 22
    to_port = 22
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }
  ingress {
    from_port = 8306
    to_port = 8306
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }
  ingress {
    from_port = 8306
    to_port = 8306
    protocol = "udp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }
  ingress {
    from_port = 5432
    to_port = 5432
    protocol = "tcp"
    cidr_blocks = ["${var.data_a_cidr}", "${var.data_b_cidr}", "${var.data_c_cidr}", "${var.twitch_vpn}", "${split(",", var.twitch_private_subnets)}"]
  }
  ingress {
    from_port = 6542
    to_port = 6545
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.vpc_cidr)}", "${split(",", var.twitch_private_subnets)}"]
  }
  ingress {
    from_port = "${var.haproxy_port_low}"
    to_port = "${var.haproxy_port_high}"
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }
  ingress {
    from_port = 2015
    to_port = 2015
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }
  tags {
    Name = "rails-${var.sg_environment}-postgres/security"
    Owner = "d8a <d8a@justin.tv>"
    Project = "web/rails-postgres"
  }
}

output "db_sec_id" {
  value = "${aws_security_group.db_sec.id}"
}
