variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "vpc_id"{
  description = "vpc-230f5e46"
}

variable "cidrs" {
  description = "10.194.12.0/24,10.194.28.0/24,10.194.44.0/24"
}

variable "environment"{
    description = "sg_environment"
}

variable "sg_description" {
  description = "security rules for the production aws postgres read replicas cluster"
}

variable "sg_name" {
  description = "discovery_replica"
}

variable "sg_project" {
  description = "web/discovery-postgres"
}


####################################
#       Simple SG                  #
####################################

resource "aws_security_group" "security_group" {
  description = "${var.sg_description}"
  name = "${var.sg_name}_${var.environment}"
  vpc_id = "${var.vpc_id}"

  lifecycle {
    create_before_destroy = true
  }
  
  egress {
    from_port = 0
    to_port = 0
    protocol = -1
    cidr_blocks = ["0.0.0.0/0"]
  }

  ingress {
    from_port = 6543
    to_port = 6543
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.cidrs)}"]
  }

  tags {
    Name = "${var.sg_name}-${var.environment}-postgres/security"
    Owner = "d8a <d8a@justin.tv>"
    Project = "${var.sg_project}"
  }
}


output "security_group_id" {
  value = "${aws_security_group.security_group.id}"
}
