
variable "vpc_id"{
  description = "vpc-230f5e46"
}

variable "vpc_cidr"{
    description = "10.194.0.0/18"
}

variable "twitch_private_subnets"{
    description = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16"
}

variable "data_cidr" {
  description = "10.194.12.0/24,10.194.28.0/24,10.194.44.0/24"
}

variable "sg_environment"{
    description = "sg_environment"
}

variable "office_wifi_vpn" {
    default  = "192.168.0.0/17,192.168.240.0/21,10.255.252.0/23,10.255.254.0/23"
}

variable "sg_description" {
  description = "security rules for the production aws postgres read replicas cluster"
}

variable "sg_name" {
  description = "discovery_replica"
}

variable "sg_project" {
  description = "web/discovery-postgres"
}

####################################
#       Simple SG                  #
####################################

resource "aws_security_group" "db_sec" {
  description = "${var.sg_description}"
  name = "${var.sg_name}_${var.sg_environment}"
  vpc_id = "${var.vpc_id}"

  lifecycle {
    create_before_destroy = true
  }

  egress {
    from_port = 0
    to_port = 0
    protocol = -1
    cidr_blocks = ["0.0.0.0/0"]
  }
  ingress {
    from_port = 22
    to_port = 22
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }
  ingress {
    from_port = 8306
    to_port = 8306
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }

  ingress {
    # required for nagios monitoring
    from_port = 5666
    to_port = 5666
    protocol = "tcp"
    cidr_blocks = ["10.192.64.0/21", "10.192.72.0/22"]
  }

  tags {
    Name = "${var.sg_name}-${var.sg_environment}-datadev/security"
    Owner = "d8a <d8a@justin.tv>"
    Project = "${var.sg_project}"
  }
}


output "db_sec_id" {
  value = "${aws_security_group.db_sec.id}"
}
