variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/d8a/provisioning.git//modules/variables/twitch-web-dev"
}

variable "sg_environment"{
  default = "dev"
}

module "d8a_dev_sg_00" {
  source = "../lib/sg.20160119/"
  sg_environment = "${var.sg_environment}"
  vpc_id = "${module.common.vpc_id}"
  vpc_cidr = "${module.common.vpc_cidr}"
  twitch_private_subnets = "${module.common.twitch_private_subnets}"
  data_a_cidr = "${module.common.data_a_cidr}"
  data_b_cidr = "${module.common.data_b_cidr}"
  data_c_cidr = "${module.common.data_c_cidr}"

}

output "sg_id" {
  value = "${module.d8a_dev_sg_00.db_sec_id}"
}

output "zk_id" {
  value = "${module.d8a_dev_sg_00.zk_sec_id}"
}
