provider "aws" {
  profile = "twitch-service-piper-dev"
  region = "us-west-2"
}
provider "aws" {
  alias = "twitch_aws"  # this is twitch-aws account(science/r53 account) 2015-10-27
  profile = "twitch-aws"
  region = "us-west-2"
}

module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}
module "common" {
  source = "../../modules/variables/twitch-web-aws/"
}

# XXX AGB: these should be coming from a remote resource. 2017-04-25
variable "data_a" {
  default = "subnet-57ffa932"
  description = "twitch_web_aws data_a"
}
variable "data_a_cidr" {
  default = "10.194.204.0/24"
}
variable "data_b" {
  default = "subnet-07f28670"
  description = "twitch_web_aws data_b"
}
variable "data_b_cidr" {
  default = "10.194.220.0/24"
}
variable "data_c" {
  default = "subnet-9dca43c4"
  description = "twitch_web_aws data_c"
}
variable "data_c_cidr" {
  default = "10.194.236.0/24"
}
variable "twitch_private_subnets"{
  default = "10.0.0.0/8,127.0.0.1/32,192.168.0.0/16"
}


resource "aws_security_group" "d8a_test_sg" {
  description = "security rules for use as a d8a development host"
  name = "d8a-test"
  vpc_id = "${module.common.vpc_id}"

  egress {
    from_port = 0
    to_port = 0
    protocol = -1
    cidr_blocks = ["0.0.0.0/0"]
  }
  ingress {
    from_port = 22
    to_port = 22
    protocol = "tcp"
    cidr_blocks = ["${split(",", var.twitch_private_subnets)}"]
  }

  tags {
    Name = "d8a-test/security"
    Owner = "d8a <d8a@justin.tv>"
    Project = "datacollection"
  }
}

data "template_file" "test_ud" {
  template="${file("test.user_data")}"
}

resource "aws_instance" "d8a_test" {
  ami = "ami-40d83e38" # base-ami xenial 2017-08-10 in us-west-2
  availability_zone = "us-west-2c"
  associate_public_ip_address = "false"
  ebs_optimized = "true"
  instance_type = "m4.large"
  monitoring = "false"
  subnet_id = "${var.data_c}"
  user_data = "${data.template_file.test_ud.rendered}"
  vpc_security_group_ids = ["${aws_security_group.d8a_test_sg.id}"]

  tags {
    Owner = "d8a@justin.tv"
    Project = "datacollection/ami-test"
  }
}

resource "aws_route53_record" "d8a_test_dns" {
  name = "devdb-${replace(aws_instance.d8a_test.id, "i-", "")}.development.twitch-web-aws.us-west2.justin.tv"
  provider = "aws.twitch_aws"
  records = ["${aws_instance.d8a_test.private_ip}"]
  ttl = "300"
  type = "A"
  zone_id = "${module.base.r53}"
}
