variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-aws"
}

module "common_local"{
  source = "../../modules/variables/twitch-web-aws/"
}

variable "cluster_name"{
  default = "zookeeper_prod"  
}

variable "topic_name" {
  default = "zookeeper_prod_topic"
}

variable "asg_name" {
  default = "zookeeper_prod_asg"
}

variable "lambda_arn" {
  default = "arn:aws:lambda:us-west-2:641044725657:function:asg_route53_update"
}

variable "aws_profile" {
  default = "zookeeper"
}

variable "twitch_environment"{
  default = "production"
} 

variable "ami" {
  default = "ami-dd11f3bd"
}

variable "cluster" {
  default = "zk"
  description = "The puppet hiera cluster for configuration"
}

variable "pg_cluster"{
  default = "zookeeper"
}

variable "instance_role"{
  default = "d8a-zookeeper"
}

variable "env" {
  default = "prod"
  description = "prod or dev -- used for naming"
}
variable "instance_name_prefix" {
  default = "zk-aws"
  description = "The dns name prefix to use -- usually the same as var.cluster"
}
variable "instance_type" {
  default = "c4.xlarge"
}
variable "subnet_id" {
  default = "subnet-57ffa932,subnet-07f28670,subnet-9dca43c4"
} 
variable "security_groups" {
  description = "Comma separated list of security group ids"
  default ="sg-3cd6a958"
}

variable "alert_interval" {
  default = "30000"
  description = "interval in milliseconds for checking status of zk and exhibitor"
}
variable "send_alert" {
  default = "true"
  description = "sending alert to pagerduty"
}
variable "statsd_cluster_name" {
  default = "zk_aws_web_prod"
  description = "the cluster name to appear in statsd/graphite"
}

variable "statsd_server" {
  default = "graphite.internal.justin.tv:8125"
  description = "statsd/graphite server"
}

variable "data_a_cidr" {
  default = "10.194.204.0/24"
}

variable "data_b_cidr" {
  default = "10.194.220.0/24"
}
variable "data_c_cidr" {
  default = "10.194.236.0/24"
}

variable "twitch_private_subnets" {
  default = "10.0.0.0/8,192.16.64.0/21,199.9.248.0/21,185.42.204.0/22,127.0.0.1/32,38.99.10.97/32,192.168.0.0/16,45.113.128.0/22,103.53.48.0/22,192.108.239.0/24,23.160.0.0/24"
}

variable "sg_environment"{
    default = "prod"
}


module "zk_prod_sg"{
  source = "../../security_groups/lib/sg.20160125/"

  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  vpc_id = "${module.common_local.vpc_id}"
  twitch_private_subnets =  "${module.common_local.twitch_private_subnets}"
  data_a_cidr =  "${module.common_local.data_a_cidr}"
  data_b_cidr =  "${module.common_local.data_b_cidr}"
  data_c_cidr =  "${module.common_local.data_c_cidr}"
  sg_environment =  "${var.sg_environment}"

}


module "zk_prod_asg_00"{
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  ami = "${var.ami}"
  source = "../lib/lib.20160107"
  instance_type = "${var.instance_type}"
  security_groups = "sg-38f4985c"
  #security_groups = "${module.zk_prod_sg.zk_sec_id}"
  instance_name_prefix = "${var.instance_name_prefix}"
  env = "${var.env}"
  cluster = "${var.cluster}"
  twitch_environment = "${var.twitch_environment}"
  vpc = "${module.common.vpc_id}"
  exhibitor_s3_config_file = "twitch-web-prod:config/exhibitor/${module.common.vpc_id}/exhibitor.properties"
  statsd_cluster_name = "${var.statsd_cluster_name}"
  statsd_server = "${var.statsd_server}"
  alert_interval = "${var.alert_interval}"
  send_alert = "${var.send_alert}"
  max_size = "5"
  min_size = "5"
  desired_capacity = "5"
  subnet_id = "${var.subnet_id}"
  pg_cluster = "${var.pg_cluster}"

}

module "notifications" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  aws_profile = "web"
  topic_name = "${var.topic_name}"
  asg_name = "${module.zk_prod_asg_00.asg_name}"
  lambda_arn = "${var.lambda_arn}"
}
