variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}

provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-dev"
}

variable "cluster_name"{
  default = "zookeeper_dev"  
}

variable "topic_name" {
  default = "zookeeper_dev_topic"
}

variable "asg_name" {
  default = "zookeeper_dev_asg"
}

variable "lambda_arn" {
  default = "arn:aws:lambda:us-west-2:465369119046:function:asg_route53_update"
}

variable "aws_profile" {
  default = "zookeeper"
}

variable "twitch_environment"{
  default = "development"
} 

variable "ami" {
  default = "ami-5e26c36d"
}

variable "cluster" {
  default = "zk"
  description = "The puppet hiera cluster for configuration"
}

variable "pg_cluster"{
  default = "zookeeper"
}

variable "instance_role"{
  default = "d8a-zookeeper"
}

variable "env" {
  default = "dev"
  description = "prod or dev -- used for naming"
}
variable "instance_name_prefix" {
  default = "zk-aws"
  description = "The dns name prefix to use -- usually the same as var.cluster"
}
variable "instance_type" {
  default = "c4.large"
}
variable "subnet_id" {
  default = "subnet-b1af88d4,subnet-1d76336a,subnet-cbd54a92"
} 
variable "security_groups" {
  description = "Comma separated list of security group ids"
  default ="sg-3cd6a958"
}

variable "alert_interval" {
  default = "30000"
  description = "interval in milliseconds for checking status of zk and exhibitor"
}
variable "send_alert" {
  default = "false"
  description = "sending alert to pagerduty"
}
variable "statsd_cluster_name" {
  default = "zk_aws_web_dev"
  description = "the cluster name to appear in statsd/graphite"
}

variable "statsd_server" {
  default = "graphite-37c291f2.dev.us-west2.justin.tv:8125"
  description = "statsd/graphit server"
}

module "zk_dev_asg_00"{
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  ami = "${var.ami}"
  source = "../lib/lib.20160107"
  instance_type = "${var.instance_type}"
  security_groups = "${var.security_groups}"
  instance_name_prefix = "${var.instance_name_prefix}"
  env = "${var.env}"
  cluster = "${var.cluster}"
  twitch_environment = "${var.twitch_environment}"
  vpc = "${module.common.vpc_id}"
  exhibitor_s3_config_file = "twitch-web-dev:config/exhibitor/${module.common.vpc_id}/exhibitor.properties"
  statsd_cluster_name = "${var.statsd_cluster_name}"
  statsd_server = "${var.statsd_server}"
  alert_interval = "${var.alert_interval}"
  send_alert = "${var.send_alert}"
  max_size = "0"
  min_size = "0"
  desired_capacity = "0"
  subnet_id = "${var.subnet_id}"
  pg_cluster = "${var.pg_cluster}"

}

module "notifications" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  aws_profile = "web-dev"
  topic_name = "${var.topic_name}"
  asg_name = "${module.zk_dev_asg_00.asg_name}"
  lambda_arn = "${var.lambda_arn}"
}
