module "base" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base?ref=terraform07"
}

provider "aws" {
  region = "us-west-2"
}

module "zk_0" {
  env = "dev"
  instance_type = "c4.large"
  r53_zone_id = "${module.base.r53}"
  security_groups = "${module.base.dev_twitch_security_group}"
  source = "../lib/lib.20151006"
  subnet_id = "${module.base.dev_subnet_b}"
  twitch_environment = "development"
  vpc = "${module.base.dev_vpc}"
  exhibitor_s3_config_file = "twitch-dev:config/exhibitor/exhibitor.properties"
  statsd_cluster_name="zk_aws_dev"
  statsd_server="graphite-37c291f2.dev.us-west2.justin.tv:8125"
  alert_interval="30000"
  send_alert="true"
}

module "zk_1" {
  env = "dev"
  instance_type = "c4.large"
  r53_zone_id = "${module.base.r53}"
  security_groups = "${module.base.dev_twitch_security_group}"
  source = "../lib/lib.20151006"
  subnet_id = "${module.base.dev_subnet_c}"
  twitch_environment = "development"
  vpc = "${module.base.dev_vpc}"
  exhibitor_s3_config_file = "twitch-dev:config/exhibitor/exhibitor.properties"
  statsd_cluster_name="zk_aws_dev"
  statsd_server="graphite-37c291f2.dev.us-west2.justin.tv:8125"
  alert_interval="30000"
  send_alert="true"
}

module "zk_2" {
  env = "dev"
  instance_type = "c4.large"
  r53_zone_id = "${module.base.r53}"
  security_groups = "${module.base.dev_twitch_security_group}"
  source = "../lib/lib.20151006"
  subnet_id = "${module.base.dev_subnet_a}"
  twitch_environment = "development"
  vpc = "${module.base.dev_vpc}"
  exhibitor_s3_config_file = "twitch-dev:config/exhibitor/exhibitor.properties"
  statsd_cluster_name="zk_aws_dev"
  statsd_server="graphite-37c291f2.dev.us-west2.justin.tv:8125"
  alert_interval="30000"
  send_alert="true"
}

module "zk_3" {
  env = "dev"
  instance_type = "c4.large"
  r53_zone_id = "${module.base.r53}"
  security_groups = "${module.base.dev_twitch_security_group}"
  source = "../lib/lib.20151006"
  subnet_id = "${module.base.dev_subnet_c}"
  twitch_environment = "development"
  vpc = "${module.base.dev_vpc}"
  exhibitor_s3_config_file = "twitch-dev:config/exhibitor/exhibitor.properties"
  statsd_cluster_name="zk_aws_dev"
  statsd_server="graphite-37c291f2.dev.us-west2.justin.tv:8125"
  alert_interval="30000"
  send_alert="true"
}

module "zk_4" {
  env = "dev"
  instance_type = "c4.large"
  r53_zone_id = "${module.base.r53}"
  security_groups = "${module.base.dev_twitch_security_group}"
  source = "../lib/lib.20151006"
  subnet_id = "${module.base.dev_subnet_a}"
  twitch_environment = "development"
  vpc = "${module.base.dev_vpc}"
  exhibitor_s3_config_file = "twitch-dev:config/exhibitor/exhibitor.properties"
  statsd_cluster_name="zk_aws_dev"
  statsd_server="graphite-37c291f2.dev.us-west2.justin.tv:8125"
  alert_interval="30000"
  send_alert="true"
}
