# python-lambda
Auto-packaging python 3.6 lambda

### Inputs

* `name`: The Lambda name in AWS, used to uniquely identify the lambda in yoru account
* `account`: Your account name (rather, the profile name used to connect to it)
* `description`: The plaintext description that will be attached to the lambda in AWS Console.
* `lambda_path`: The folder that the lambda data is contained in.  Usually something like `${path.module}/lambda-source/`

#### Optional
* `region`: Region to provision the Lambda in, defaults to `us-west-2`
* `handler`: The python method to launch, in the form `filename.method`.  Defaults to `lambda.run`, to execute the `run` method in `lambda.py`
* `memory`: Memory to provide lambda executions with.  Defaults to `128` for 128MB
* `timeout`: Execution timeout on the lambda.  Defaults to `3` for 3 seconds.

#### Using Virtualenvs

If you need python libraries other than the system libs, you can provide the optional
  variable `virtualenv`, with the name of your virtual python environment.  If you do
  that, it's a good idea to include a requirements.txt with your terraform script so
  that other developers can easily re-establish your virtualenv locally.

However, there are some necessary steps to configure your workstation to use
  virtualenvs in a way that allows this module to conveniently locate your env
  by name.

Execute the following locally:

```
sudo pip3 install virtualenvwrapper
```

Then add the following to the file `~/.bashrc` (you may have to create it):

```
export WORKON_HOME=<your virtulaenv directory>
VIRTUALENVWRAPPER_PYTHON='/usr/local/bin/python3'
source /usr/local/bin/virtualenvwrapper.sh
```

Add the following to the file `~/.bash_profile`:

```
export BASH_ENV='~/.bashrc'
source "$BASH_ENV"
```

This will allow you to use the `workon <env name>` command to switch virtualenvs,
  and will make that command available to non-interactive shells.

After doing this, you can provide the `virtualenv` optional variable to this module
  to package the env's installed libraries with your lambda.

### Outputs

* `role_name`: The name of the IAM role created for the Lambda
* `role_arn`: The ARN of the IAM role created for the Lambda
* `lambda_arn`: The ARN of the created Lambda (does not include the version component - you'll often need to do something like "${module.lambda.lambda_arn}:$LATEST"
* `deploy_package`: The file system path to the created deployment zip
