resource "aws_iam_role" "iam_for_lambda" {
    name = "lambda-${var.name}"

    assume_role_policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Action": "sts:AssumeRole",
            "Principal": {
                "Service": "lambda.amazonaws.com"
            },
            "Effect": "Allow",
            "Sid": ""
        }
    ]
}
EOF
}

data "external" "package_deploy_file" {
    program = ["bash", "${path.module}/envlaunch.sh", "${path.module}/package.py", " ${var.virtualenv}"]

    query {
        lambda = "${var.lambda_path}"
        output = "${path.module}/deploy/deploy.zip"
    }
}

resource "aws_lambda_function" "lambda" {
    filename         = "${lookup(data.external.package_deploy_file.result, "out_file")}"
    function_name    = "${var.name}"
    role             = "${aws_iam_role.iam_for_lambda.arn}"
    handler          = "${var.handler}"
    source_code_hash = "${base64sha256(file(lookup(data.external.package_deploy_file.result, "out_file")))}"
    runtime          = "python3.6"

    description      = "${var.description}"
    memory_size      = "${var.memory}"
    timeout          = "${var.timeout}"
    publish          = true
    environment      = {
      variables = "${var.environment_variables}"
    }
}

output "role_name" {
    value = "${aws_iam_role.iam_for_lambda.name}"
}

output "role_arn" {
    value = "${aws_iam_role.iam_for_lambda.arn}"
}

output "lambda_arn" {
    value = "${aws_lambda_function.lambda.arn}"
}

output "deploy_package" {
    value = "${path.module}/deploy/deploy.zip"
}
