#!/usr/env/python

import json
import sys
import os
import zipfile
import glob

current_venv = ""
if len(sys.argv) > 1 and sys.argv[1]:
    current_venv = os.environ.get('VIRTUAL_ENV', '')

inputObj = json.load(sys.stdin)
lambda_dir = inputObj['lambda']
out_file = inputObj['output']
baselambdastart = len(lambda_dir)

try:
    os.makedirs(os.path.dirname(out_file))
except OSError:
    pass

with zipfile.ZipFile(out_file, 'w', zipfile.ZIP_DEFLATED) as myZip:
    for base, dirs, files in os.walk(lambda_dir):
        for file in files:
            fullpath = os.path.join(base, file)
            myZip.write(fullpath, fullpath[baselambdastart:])

    if current_venv:
        for sitepackages in glob.iglob(os.path.join(current_venv, "lib/python*/site-packages")):
            basevenvstart = len(sitepackages)
            for base, dirs, files in os.walk(sitepackages):
                for file in files:
                    fullpath = os.path.join(base, file)
                    myZip.write(fullpath, fullpath[basevenvstart:])

print(json.dumps({'out_file': out_file}))
