###### Data access guide
* Zenyatta outputs all data to `s3://science-input/dbsnapshots/<YYYYMMDDTHHMMSS>` where the `<>` part is a UTC timestamp of the data
* The s3 bucket lives in `twitch-aws`
* The `YYYYMMDDTHHMMSS` timestamp represents the age of the last write to the data source. It is the entire datasource up until that point in time. 
* `s3://science-input/dbsnapshots/<YYYYMMDDTHHMMSS>/<data source>/`  inside each time stamped directory is a folder for each source of data
        * `s3://science-input/dbsnapshots/<YYYYMMDDTHHMMSS>/<data source>/<table>.csv` for each table there is a csv file
        * each table csv file has a header file with the column names
        * each data source direcory has a json file called `metadata.json` 
            * the first key in the json blob is the database schema. 
                * the schema key points to a dictionary with keys for each table.
                * Here's the cohesion-chat metadata.json
```
        {
  "cohesion": {
    "associations": [
      {
        "autoincrement": true,
        "name": "id",
        "default": "nextval('associations_id_seq'::regclass)",
        "type": "INTEGER",
        "nullable": false
      },
      {
        "autoincrement": false,
        "name": "from_id",
        "default": null,
        "type": "INTEGER",
        "nullable": false
      },
      {
        "autoincrement": false,
        "name": "from_kind",
        "default": null,
        "type": "VARCHAR",
        "nullable": false
      },
      {
        "autoincrement": false,
        "name": "to_id",
        "default": null,
        "type": "INTEGER",
        "nullable": false
      },
      {
        "autoincrement": false,
        "name": "to_kind",
        "default": null,
        "type": "VARCHAR",
        "nullable": false
      },
      {
        "autoincrement": false,
        "name": "assoc_kind",
        "default": null,
        "type": "VARCHAR",
        "nullable": false
      },
      {
        "autoincrement": false,
        "name": "data_bag",
        "default": null,
        "type": "JSONB",
        "nullable": false
      },
      {
        "autoincrement": false,
        "name": "creation_date",
        "default": "timezone('UTC'::text, now())",
        "type": "TIMESTAMP WITH TIME ZONE",
        "nullable": false
      }
    ],
    "counts": [
      {
        "autoincrement": false,
        "name": "from_id",
        "default": null,
        "type": "INTEGER",
        "nullable": false
      },
      {
        "autoincrement": false,
        "name": "from_kind",
        "default": null,
        "type": "VARCHAR",
        "nullable": false
      },
      {
        "autoincrement": false,
        "name": "assoc_kind",
        "default": null,
        "type": "VARCHAR",
        "nullable": false
      },
      {
        "autoincrement": false,
        "name": "to_kind",
        "default": null,
        "type": "VARCHAR",
        "nullable": false
      },
      {
        "autoincrement": false,
        "name": "count",
        "default": "0",
        "type": "INTEGER",
        "nullable": true
      }
    ]
  }
}
```