#####This guide is intended to help someone clone the repo, make changes, and deploy them to the production cluster

#####Setup environment
* first clone the repo

```git clone https://git-aws.internal.justin.tv/d8a/zenyatta.git```
* make a virtual environment, see https://virtualenvwrapper.readthedocs.io/en/latest/ if you don't have `virtualenvwrapper` in your dev environment

```
# ensure you're in the zenyatta dir you just cloned
mkvirtualenv -p python3.5 zenyatta
setvirtualenvproject
pip install -U pip
pip install -r requirements.txt
```
* at this point you should have a working python environment. Check by typing:
```
# first command is a virtualenvwrapper command to enable the virtual environment
workon zenyatta
airflow list_dags
```

##### Create a feature branch
* create a feature branch
```
git checkout -b my_feature_branch
```
* if you'd like to add a new DAG, look at the existing DAGs at: https://git-aws.internal.justin.tv/d8a/zenyatta/tree/master/base/dags
* airflow enforces 1 DAG per file in that directory. The file can be named anything. The scheduler will periodically run these files to update it's view of the world and what DAGs exist
* If you need to add tasks, see: https://git-aws.internal.justin.tv/d8a/zenyatta/blob/master/base/tasks.py
  * to incorporate these new tasks into a pipeline, or a brand new pipeline add your task incantation to: https://git-aws.internal.justin.tv/d8a/zenyatta/blob/master/base/pipelines.py
    * the pipelines file contains 2 pipelines. One for RDS instances, and one for twitch managed SQL instances. 
    * there's no reason tehre can't be more pipelines
* after you've added what code you'd like, attempt a simple sanity check by running it manually from the command line in your dev environment
```
# from zenyatta top level directory
workon zenyatta
python base/dags/your_fancy_new_dag.py
```
* Running that command is basically compiling your code. Python will only check for obvious syntax errors and wont expose any run time issues.
* If that succeeds, push your feature branch:
```
git push origin my_feature_branch
```

###### Deploy 
* go to http://clean-deploy.internal.justin.tv/#/d8a/zenyatta
* select your branch, and deploy to development
* run puppet on airflow nodes