import boto3
import argparse
from time import sleep
from botocore.exceptions import ClientError

parser = argparse.ArgumentParser(description="removes ebs volumes from tags")

parser.add_argument('-p', '--profile', required=True, dest='profile', action='store',
                    help='aws account to use')

parser.add_argument('-n', '--name', required=True, dest='tag', action='store',
                    help='string to search in Name Tag')

parser.add_argument('-r', '--region', required=False, dest='region',
                    action='store',
                    help='string to search in Name Tag',
                    default='us-west-2')

args = parser.parse_args()

sesh = boto3.Session(profile_name=args.profile, region_name=args.region)

rds = sesh.client('ec2')

all_meta = []
some_meta = rds.describe_volumes(Filters=[{'Name': 'tag:name', 'Values': [args.tag]}])
all_meta.append(some_meta)
try:
    # for pagination through results if there's more than 100 dbs in your aws account
    marker = some_meta['NextToken']
    while 'NextToken' in some_meta:
        some_meta = rds.describe_volumes(
            NextToken=marker,
            Filters=[{'Name': 'tag:name', 'Values': [args.tag]}])
        all_meta.append(some_meta)
except KeyError:
    pass


to_remove = []
for metadata in all_meta:
    for volume in metadata['Volumes']:
        tags = [tag for tag in volume['Tags'] if tag['Key'] == 'name' and args.tag == tag['Value']]
        if len(tags) > 0:  # be explicit that i want something returned
            to_remove.append(volume['VolumeId'])

instance_string = '\n'.join(to_remove)
print("number of volumes to remove: " + str(len(to_remove)))

for volume in to_remove:
    print("removing: {volume}".format(**locals()))
    try:
        resp = rds.delete_volume(VolumeId=volume)
        print("removing response: {resp}".format(**locals()))
    except ClientError as ce:
        print("failed to remove {ce}".format(**locals()))
        msg = ce.response['Error']['Message']
        if 'currently attached' in msg:
            instance_id = msg.split()[-1]
            print("detaching from " + instance_id)
            rds.detach_volume(VolumeId=volume, Force=True, InstanceId=instance_id)
            sleep(30)
            print("deleting " + volume + " again")
            resp = rds.delete_volume(VolumeId=volume)
            print("removing response: {resp}".format(**locals()))
