import boto3
import argparse
from time import sleep

from botocore.exceptions import ClientError

parser = argparse.ArgumentParser(description="removes ec2 instances based on tags")

parser.add_argument('-p', '--profile', required=True, dest='profile', action='store',
                    help='aws account to use')

parser.add_argument('-n', '--name', required=True, dest='tag', action='store',
                    help='string to search in Name Tag')

parser.add_argument('-r', '--region', required=False, dest='region',
                    action='store',
                    help='string to search in Name Tag',
                    default='us-west-2')

args = parser.parse_args()

sesh = boto3.Session(profile_name=args.profile, region_name=args.region)

ec2 = sesh.client('ec2')

some_meta = ec2.describe_instances()
all_meta = [instance for meta in some_meta['Reservations']
            for instance in meta['Instances']
            if 'Tags' in instance
            for tag in instance['Tags']
            if args.tag in tag['Value']]
try:
    # for pagination through results if there's more than 100 dbs in your aws account
    marker = some_meta['NextToken']
    while 'NextToken' in some_meta:
        some_meta = ec2.describe_volumes()
        for instance in [instance for meta in some_meta['Reservations']
                         for instance in meta['Instances']
                         if 'Tags' in instance
                         for tag in instance['Tags']
                         if args.tag in tag['Value']]:
            all_meta.append(instance)
except KeyError:
    pass


print(ec2.terminate_instances(InstanceIds=[meta['InstanceId'] for meta in all_meta]))
