import boto3
import argparse

from botocore.exceptions import ClientError

from zenyatta.common.util import query_yes_no

parser = argparse.ArgumentParser(description="removes nodes from tags")

parser.add_argument('-p', '--profile', required=True, dest='profile',
                    action='store', help='aws account to use')

parser.add_argument('-n', '--name', required=True, dest='tag', action='store',
                    help='string to search in Name Tag')

parser.add_argument('-r', '--region', required=False, dest='region',
                    action='store',
                    help='string to search in Name Tag',
                    default='us-west-2')

args = parser.parse_args()

sesh = boto3.Session(profile_name=args.profile, region_name=args.region)

rds = sesh.client('rds')

all_meta = []
some_meta = rds.describe_db_instances()
all_meta.append(some_meta)
try:
    # for pagination through results if there's more than 100 dbs in your aws account
    marker = some_meta['Marker']
    while 'Marker' in some_meta:
        some_meta = rds.describe_db_instances(Marker=marker)
        all_meta.append(some_meta)
except KeyError:
    pass


to_remove = []
for metadata in all_meta:
    for instance in metadata['DBInstances']:
        if args.tag in instance['DBInstanceIdentifier']:
            to_remove.append(instance['DBInstanceIdentifier'])

if len(to_remove) > 0:
    instance_string = '\n'.join(to_remove)
    print("number of instances to remove: " + str(len(to_remove)))

    if query_yes_no("do you want to remove: " + " ".join(to_remove)):
        for instance in to_remove:
            print("removing: {instance}".format(**locals()))
            try:
                resp = rds.delete_db_instance(DBInstanceIdentifier=instance, SkipFinalSnapshot=True)
                print("removing response: {resp}".format(**locals()))
            except ClientError as ce:
                print("failed to remove {ce}".format(**locals()))
