# REDIS
provider "aws" {
  alias = "${var.account}"
  region = "${var.region}"
  profile = "${var.account}"
}

resource "aws_elasticache_subnet_group" "elasticache_subnet" {
  provider = "aws.${var.account}"
  name = "${var.service}-${var.environment}"
  description = "subnet for ${var.service}"
  subnet_ids = ["${var.subnet_ids}"]
}

resource "aws_elasticache_cluster" "elasticache" {
    cluster_id = "${var.service}-${var.environment}"
    engine = "${var.engine}"
    engine_version = "${var.engine_version}"
    node_type = "${var.node_type}"
    port = "${var.port}"
    num_cache_nodes = "${var.num_cache_nodes}" # for redis this must be 1, and only 1? lol https://www.terraform.io/docs/providers/aws/r/elasticache_cluster.html#num_cache_nodes
    parameter_group_name = "${var.parameter_group_name}"
    security_group_ids  = ["${var.security_group_ids}"]
    subnet_group_name = "${aws_elasticache_subnet_group.elasticache_subnet.name}"

  tags {
    Name = "${var.service}-${var.environment}"
    Environment = "${lookup(var.environment_tagname, var.environment)}"
    Owner = "${var.owner}@twitch.tv"
    Service = "${var.owner}/${var.service}"
  }
}
