# Input arguments, required

variable "account" {}
variable "security_group_ids" { type = "list" }
variable "subnet_ids" { type = "list" }
variable "environment" {}
variable "parameter_group_name" {}
variable "service" {}
variable "engine" { default = "redis" }
variable "engine_version" { default = "2.8.24" }
variable "node_type" { default = "cache.m3.medium" }
variable "num_cache_nodes" { default = 1 }
variable "size" { default = "200" }
variable "port" { default = "6379" }
variable "owner" {}

# Input arguments, optional
variable "region" { default = "us-west-2" }

# Internal variables, mostly maps to use to generate secondary variables
# based on the passed in arguments
# For use with creating FQDNs
variable "environment_shortname" {
  type = "map"
  default = {
    production = "prod"
    staging = "staging"
    development = "dev"
  }
}

variable "dns_region" {
  type = "map"
  default = {
    us-west-2 = "us-west2"
    us-east-1 = "us-east1"
  }
}

# For use with tagging semantics as laid out
# by the capacity planing team. Used as the Environment
variable "environment_tagname" {
  type = "map"
  default = {
    production = "prod"
    staging = "stage"
    development = "dev"
  }
}

