# RDS
provider "aws" {
  alias = "${var.account}"
  region = "${var.region}"
  profile = "${var.account}"
}

resource "aws_db_instance" "instance" {
  provider = "aws.${var.account}"
  identifier = "${var.identifier}"
  allocated_storage = "${var.size}" #space in gigs
  backup_retention_period = "${var.backup_retention_period}"
  engine = "postgres"
  instance_class = "${var.instance_class}"
  name = "airflow"
  username = "${var.username}"
  password = "${var.password}"
  multi_az = "${var.multi_az}"
  db_subnet_group_name = "${var.subnet_group_name}"
  vpc_security_group_ids = ["${var.vpc_security_group_ids}"]
  port = "${var.port}"
  tags {
    Name = "${var.identifier}-${var.environment}"
    Environment = "${lookup(var.environment_tagname, var.environment)}"
    Owner = "${var.owner}@twitch.tv"
    Service = "${var.owner}/${var.identifier}"
  }
}
