# Input arguments, required

variable "account" {}
variable "subnet_group_name" {}
variable "vpc_security_group_ids" { type = "list" }
variable "environment" {}
variable "identifier" {}
variable "instance_class" { default = "db.m4.xlarge" }
variable "backup_retention_period" { default = "7" }
variable "password" { default = "airflow1234" }
variable "username" { default = "airflow" }
variable "multi_az" { default = false }
variable "size" { default = "200" }
variable "port" { default = 5432 }
variable "owner" {}

# Input arguments, optional
variable "region" { default = "us-west-2" }

# Internal variables, mostly maps to use to generate secondary variables
# based on the passed in arguments
# For use with creating FQDNs
variable "environment_shortname" {
  type = "map"
  default = {
    production = "prod"
    staging = "staging"
    development = "dev"
  }
}

variable "dns_region" {
  type = "map"
  default = {
    us-west-2 = "us-west2"
    us-east-1 = "us-east1"
  }
}

# For use with tagging semantics as laid out
# by the capacity planing team. Used as the Environment
# tag given to the EC2 instance
variable "environment_tagname" {
  type = "map"
  default = {
    production = "prod"
    staging = "stage"
    development = "dev"
  }
}

# Outputs
output "instance_ids" { value = ["${aws_db_instance.instance.*.id}"] }

