# SAAAA-curitah
provider "aws" {
  alias = "${var.account}"
  region = "${var.region}"
  profile = "${var.account}"
}

resource "aws_security_group" "security_group" {
    name = "${var.service}-${var.environment}"
    description = "security group for redis, postgres, and celery"
    vpc_id = "${var.vpc_id}"

  egress {
    from_port = 0
    to_port = 0
    protocol = -1
    cidr_blocks = ["0.0.0.0/0"]
  }
    ingress {
    from_port = 22
    to_port = 22
    protocol = "tcp"
    cidr_blocks = "${var.subnets}"
  }
    ingress { # airflow worker port
    from_port = 8793
    to_port = 8793
    protocol = "tcp"
    cidr_blocks = "${var.subnets}"
  }
    ingress { # elasticache port
    from_port = 6379
    to_port = 6379
    protocol = "tcp"
    cidr_blocks = "${var.subnets}"
  }
    ingress { # default webserver port
    from_port = 8080
    to_port = 8080
    protocol = "tcp"
    cidr_blocks = "${var.subnets}"
  }
  ingress { # consul
    from_port = 8000
    to_port = 8000
    protocol = "tcp"
    cidr_blocks = "${var.subnets}"
  }
  ingress { # consul
    from_port = 8306
    to_port = 8306
    protocol = "tcp"
    cidr_blocks = "${var.subnets}"
  }
  ingress { # consul
    from_port = 8306
    to_port = 8306
    protocol = "udp"
    cidr_blocks = "${var.subnets}"
  }
    ingress { # nginx port
    from_port = 80
    to_port = 80
    protocol = "tcp"
    cidr_blocks = "${var.subnets}"
  }
  ingress { # elb ssl termination port
    from_port = 443
    to_port = 443
    protocol = "tcp"
    cidr_blocks = "${var.subnets}"
  }
    ingress { # rds port
    from_port = 5432
    to_port = 5432
    protocol = "tcp"
    cidr_blocks = "${var.subnets}"
  }

  ingress {
    # required for nagios monitoring
    from_port = 5666
    to_port = 5666
    protocol = "tcp"
    cidr_blocks = "${var.subnets}"
  }

  ingress { # celery ui port
    from_port = 5555
    to_port = 5555
    protocol = "tcp"
    cidr_blocks = "${var.subnets}"
  }

  tags {
  	Name = "${var.service}-${var.environment}"
  	Owner = "${var.owner}@twitch.tv"
  }
}


