# Input arguments, required

variable "account" {}
variable "vpc_id" {}
variable "subnets" { type = "list" }
variable "environment" {}
variable "service" {}
variable "owner" {}

# Input arguments, optional
variable "region" { default = "us-west-2" }

# Internal variables, mostly maps to use to generate secondary variables
# based on the passed in arguments
# For use with creating FQDNs
variable "environment_shortname" {
  type = "map"
  default = {
    production = "prod"
    staging = "staging"
    development = "dev"
  }
}

variable "dns_region" {
  type = "map"
  default = {
    us-west-2 = "us-west2"
    us-east-1 = "us-east1"
  }
}

# For use with tagging semantics as laid out
# by the capacity planing team. Used as the Environment
variable "environment_tagname" {
  type = "map"
  default = {
    production = "prod"
    staging = "stage"
    development = "dev"
  }
}

output "security_group_ids" { value = ["${aws_security_group.security_group.id}"] }
