import json
from zenyatta.aws.sns import generate_etl_finished_message, generate_s3_path_for_finished_message
from tests.static.constants import TS_NODASH


def test_generate_etl_finished_sns_message():
    s3path = 's3://this/is/a/finished/bucket'
    job_id = 'testdb'
    message = json.loads(generate_etl_finished_message(s3path, job_id))
    assert 's3_path' in message.keys()
    assert 'job_id' in message.keys()
    assert message['s3_path'] == s3path
    assert message['job_id'] == job_id


def test_generate_s3_path_for_finished_message():
    meta = {'bucket': 'bucket', 's3_key': 'key'}
    job_id = 'testdb'
    s3path = generate_s3_path_for_finished_message(meta, TS_NODASH, job_id)
    assert s3path.startswith('s3://'+meta['bucket'])
    assert s3path.endswith(job_id)
    assert s3path == 's3://' + meta['bucket'] + '/' + meta['s3_key'] + '/' + TS_NODASH + '/' + job_id
