import unittest
# from unittest.mock import patch
from time import sleep
from unittest import mock

from zenyatta.docker import DockerContainer, PostgresContainer
from airflow.operators.python_operator import PythonOperator
from zenyatta.tasks import check_postgres_pg_isready_task, poll_pg_isready
from tests.util import get_connection, get_dag

# from tests.util import get_connection


class dummyConnection(dict):
    """dot.notation access to dictionary attributes"""
    __getattr__ = dict.get
    __setattr__ = dict.__setitem__
    __delattr__ = dict.__delitem__


class ElasticCacheTestCase(unittest.TestCase):

    @unittest.skip("pass and skip")
    def test_simple_container(self):
        DOCKER_PS = (b'CONTAINER ID        IMAGE                                                          '
                     b'         COMMAND                  CREATED             STATUS              PORTS    '
                     b'                NAMES\n9b2bc28ab1c5        641044725657.dkr.ecr.us-west-2.amazonaws'
                     b'.com/d8a/postgres-pitr:latest   "/docker-entrypoint.s"   25 hours ago        Up 25 '
                     b'hours         0.0.0.0:5897->5432/tcp   sitedb-20161215T000000\n21dd98c4e4c3        '
                     b'641044725657.dkr.ecr.us-west-2.amazonaws.com/d8a/postgres-pitr:latest   "/docker-en'
                     b'trypoint.s"   2 days ago          Up 2 days           0.0.0.0:5185->5432/tcp   site'
                     b'db-20161215T040000\naf2011501fc7        641044725657.dkr.ecr.us-west-2.amazonaws.co'
                     b'm/d8a/postgres-pitr:latest   "/docker-entrypoint.s"   2 days ago          Up 2 days'
                     b'           0.0.0.0:5479->5432/tcp   sitedb-20161214T120000\n68de2bed0a9d        641'
                     b'044725657.dkr.ecr.us-west-2.amazonaws.com/d8a/postgres-pitr:latest   "/docker-entry'
                     b'point.s"   2 days ago          Up 2 days           0.0.0.0:5533->5432/tcp   sitedb-'
                     b'20161214T040000\n8ee773eeee53        641044725657.dkr.ecr.us-west-2.amazonaws.com/d'
                     b'8a/postgres-pitr:latest   "/docker-entrypoint.s"   2 days ago          Up 2 days   '
                     b'        0.0.0.0:5944->5432/tcp   sitedb-20161214T200000\n1844a67469ae        641044'
                     b'725657.dkr.ecr.us-west-2.amazonaws.com/d8a/postgres-pitr:latest   "/docker-entrypoi'
                     b'nt.s"   2 days ago          Up 2 days           0.0.0.0:5566->5432/tcp   sitedb-201'
                     b'61214T080000\na1bf899fff97        641044725657.dkr.ecr.us-west-2.amazonaws.com/d8a/'
                     b'postgres-pitr:latest   "/docker-entrypoint.s"   2 days ago          Up 2 days      '
                     b'     0.0.0.0:5997->5432/tcp   sitedb-20161214T160000\n2aa8872ccd0a        641044725'
                     b'657.dkr.ecr.us-west-2.amazonaws.com/d8a/postgres-pitr:latest   "/docker-entrypoint.'
                     b's"   2 days ago          Up 2 days           0.0.0.0:5218->5432/tcp   sitedb-201612'
                     b'14T000000\n')
        CONTAINER = 'sitedb-20161214T120000'
        container = DockerContainer(name=CONTAINER, host='localhost')
        assert container.name == CONTAINER

    @unittest.skip("pass and skip")
    def test_wait_for_pg_ready(self):
        conn_dict = {'host': '10.194.204.117', 'id': 'chat_depot'}
        connection = dummyConnection(conn_dict)
        self.assertEqual(wait_for_pg_ready(connection)['status'], True)

    @unittest.skip("pass and skip")
    def test_wait_for_pg_ready(self):
        conn_dict = {'host': '10.194.12.132', 'id': 'justintv_dev'}
        connection = dummyConnection(conn_dict)
        # with self.assertRaises(Exception):
        wait_for_pg_ready(connection)

    @unittest.skip("pass and skip")
    def test_check_postgres_pg_isready_task(self):
        conn = get_connection()
        dag = get_dag()
        task = check_postgres_pg_isready_task(conn, dag)
        self.assertEqual(task.op_kwargs.get('conn_id'), conn.conn_id)
        self.assertTrue('cleanup_aws' in task.op_kwargs)

    @unittest.skip("pass and skip")
    def test_poll_pg_1(self):
        conn_dict = {'host': '10.194.12.132', 'id': 'justintv_dev'}
        connection = dummyConnection(conn_dict)
        self.assertTrue(poll_pg_isready(connection, 10))

    @mock.patch('zenyatta.tasks.sleep', return_value=sleep(1))
    @unittest.skip("pass and skip")
    def test_poll_pg_1(self, sleep_mock):
        # TODO mock response from pg_isready and don't acually ssh into anything
        conn_dict = {'host': '10.194.204.117', 'id': 'chat_depot'}
        connection = dummyConnection(conn_dict)
        self.assertFalse(poll_pg_isready(connection, 10))


if __name__ == '__main__':
    unittest.main()
