import unittest
from zenyatta.aws.redis import ElasticCache
from scripts.setup_redis import parse_config_file


class ElasticCacheTestCase(unittest.TestCase):
    """docstring for ElasticCacheTestCase"""

    # preparing to test
    def setUp(self):
        """ Setting up for the test """
        pass

    # ending the test
    def tearDown(self):
        """Cleaning up after the test"""
        # TODO: delete test cluster and snapshot. now i manually delete them
        pass

    # test routine A
    @unittest.skip("pass and skip")
    def test_parse_config_file(self):
        """Test parse_config_file """
        print("parse_config_file:testA")
        with self.assertRaises(Exception):
            parse_config_file('/etc/zenyatta/abc.yml')
        rtn = parse_config_file('/etc/zenyatta/redis_cfg.yaml')
        self.assertIsNotNone(rtn)
        self.assertEqual(rtn['redis']['region'], 'us-west-2')

    @unittest.skip("pass and skip")
    def test_fetch_cache_clusters(self):
        """Test fetch_cache_clusters"""
        ec = ElasticCache('elasticache')
        rtn = ec.fetch_cache_clusters('donot-exist')
        self.assertEqual(rtn, [])
        rtn = ec.fetch_cache_clusters('buddy-d8a-team')
        self.assertEqual(rtn[0]['CacheClusterId'], 'buddy-d8a-team')

    @unittest.skip("pass and skip")
    def test_create_cache_clusters(self):
        redis_cfg = parse_config_file('/etc/zenyatta/redis_cfg.yaml')
        cache_cluster_id = 'buddy-d8a-dummy'
        cache_cluster_tag = cache_cluster_id
        subnet_group = 'zenyatta-development'
        security_group_list = []
        security_group_list.append('sg-0954cd72')
        ec = ElasticCache('elasticache')
        cc = ec.create_redis_cluster(redis_cfg, cache_cluster_id, cache_cluster_tag, subnet_group,
                                     security_group_list)
        self.assertIsNotNone(cc)

    @unittest.skip("pass and skip")
    def test_delete_cache_clusters(self):
        ec = ElasticCache('elasticache')
        rtn = ec.delete_cache_cluster('buddy-d8a-dummy')
        self.assertIsNotNone(rtn)


if __name__ == '__main__':
    unittest.main()
