from collections import namedtuple
from datetime import datetime
import boto3

from airflow.models import Connection
from dateutil.tz import tzlocal

from tests.static.responses import VOLUME_ATTACHMENTS

DAG = namedtuple('DAG', ['default_args', 'params'])
TaskInstance = namedtuple('TaskInstance', ['xcom_push', 'dag_id'])
Instance = namedtuple('Instance', ['id', 'image_id',
                                   'instance_type', 'security_groups',
                                   'tags', 'block_device_mappings'])

Volume = namedtuple('Volume', ['id', 'attachments'])

AWS_CREDS = {'access_key': "key",
             'secret_key': "secret",
             'region': 'us-west-2'}

AWS_META = {'test': {
    'access_key': 'key',
    'secret_key': 'secret',
    'region': 'us-west-2',
    'bucket': 's3://d8a-chat-backup/postgres/chat_depot_production/wale/',
    'schema': 'chat_depot'}}


def get_ebs_volume(id='vol-01dd23089a7477148', attachments=VOLUME_ATTACHMENTS.copy(),
                   ):
    return Volume(id=id, attachments=attachments)


def get_ec2_instance(id='i-0f2dfeedcee401a1c', image_id='ami-a66dccc6', instance_type='gp2',
                     security_groups=[{'GroupId': 'sg-86b828fe', 'GroupName': 'zenyatta-sg'}],
                     tags=[{'Key': 'Name', 'Value': 'zenyatta-master-dev-development'},
                           {'Key': 'instance-d8a-zenyatta-master-dev-development', 'Value': '1'},
                           {'Key': 'Owner', 'Value': 'd8a@twitch.tv'},
                           {'Key': 'Environment', 'Value': 'dev'},
                           {'Key': 'Service', 'Value': 'd8a/zenyatta/zenyatta-master-dev'}],
                     block_device_mappings=[{
                         'DeviceName': '/dev/sda1',
                         'Ebs': {'AttachTime': datetime(2017, 2, 3, 21, 34, 44, tzinfo=tzlocal()),
                                 'DeleteOnTermination': True,
                                 'Status': 'attached',
                                 'VolumeId': 'vol-03cc40ac1f1d598eb'}}]):
    return Instance(id=id, image_id=image_id,
                    instance_type=instance_type, security_groups=security_groups,
                    tags=tags, block_device_mappings=block_device_mappings)


def get_connection(conn_id='test', conn_type='Postgres',
                   host='test.cifgffw7w2ar.us-west-2.rds.amazonaws.com', login='login', port=5432):

    return Connection(conn_id=conn_id, conn_type=conn_type, host=host, login=login, port=port)


def get_dag(default_args={'s3_output': {'role_arn': "arn:aws:iam::465361111111:role/test",
                                        'bucket': 'twitch-d8a-test',
                                        's3_key': 'etl',
                                        'region': 'us-west-2'},
                          'sns_output': {'role_arn': '',
                                         'sns_arn': ''},
                          'rds_creds': {'access_key': "key",
                                        'secret_key': "secret",
                                        'region': 'us-west-2'},
                          'sns_creds': {'role_arn': "arn:aws:iam::465361111111:role/test",
                                        'access_key': 'key',
                                        'secret_key': "secret",
                                        "region": "us-west-2"},
                          "ec2_creds": {'access_key': 'key',
                                        'secret_key': "secret",
                                        "region": "us-west-2"}}):
    from airflow.models import DAG
    return DAG('test-etl', default_args=default_args, start_date=datetime.now())


def get_task_instance():
    return TaskInstance(xcom_push=lambda key, value: True, dag_id="test-etl")
