class XcomKey:
    def __init__(self, task_instance, ts_nodash):
        self.task_instance = task_instance
        self.ts_nodash = ts_nodash

    def key_chain(self):
        return [self.task_instance.dag_id, self.ts_nodash]

    def get_key(self):
        return self.key_chain()[0] + self.id + self.key_chain()[1]


class XcomInstanceIdKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-instance_id-'


class XcomVolumeIdKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-volume_id-'


class XcomConnIdKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-conn_id-'


class XcomPGReadyKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-pg_isready-'


class XcomSparkScriptKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-spark_script-'


class XcomSparkConfigKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-spark_config-'


class XcomSparkSubmitKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-spark_submit_flag-'


class XcomRDSIdKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-rds_id-'


class XcomDBConnIdKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-db_tmp_conn_id-'


class XcomCSVKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-csv-'


class XcomBucketKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-bucket-'


class XcomRoleArnKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-role_arn-'


class XcomS3ScriptKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-s3_script_path-'


class XcomLocalScriptKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-local_script-'


class XcomS3PQKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-s3_parquet-'


class XcomLocalPQKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-local_parquet-'


class XcomTablesKey(XcomKey):
    def __init__(self, task_instance, ts_nodash):
        XcomKey.__init__(self, task_instance, ts_nodash)
        self.id = '-tables-'
