import datetime
from airflow import DAG
from airflow.operators.python_operator import PythonOperator
from zenyatta.aws import boto_client

default_args = {
    'owner': 'DANG',
    'retries': 3,
    'retry_delay': datetime.timedelta(minutes=5),
    'start_date': datetime.datetime(2017, 11, 1),
}


def destroy_pitr_instance(ds, **kwargs):
    rds_client, _ = boto_client('rds')
    rds_client.delete_db_instance(
        DBInstanceIdentifier=kwargs['dag_run'].conf['identifier'],
        SkipFinalSnapshot=True,
    )


with DAG('cleanup_single_instance',
         default_args=default_args,
         schedule_interval=None,
         max_active_runs=4,
         ) as dag:

    destroy_pitr_instance = PythonOperator(
        task_id='destroy_pitr_instance',
        dag=dag,
        provide_context=True,
        python_callable=destroy_pitr_instance
    )
