# Destiny

Reliably deliver messages at some future time to other systems (SQS, State Machines, Lambda, etc...).

## Getting Started

```bash
$ docker-compose up -d
$ go run cmd/destiny/main.go service
```

This will run the twirp service on `http://localhost:3000`.

## Events

Events have a few important attributes:

- `Domain` (string) &mdash; namespaces events per team or arbitrary group. For example the subscriptions team may use a domain of "subChannel" for messages that are for subscription changes.
- `Destination` (string) &mdash; a URL format that controls where the message will be delivered to. e.g., `sqs://$queueName` would use the `sqs` destination. `state://$arn` would trigger a state machine execution.
- `Payload` (bytes) &mdash; Arbitrary payload that can be JSON, protobufs, etc...
- `SendAt` (timestamp) &mdash; Event will be delivered at this timestamp or a few seconds after.

## Sending Events

Events can be sent via the `CommitEvent` twirp endpoint. This will reliably store the event until it can be delivered.

```bash
curl -X POST http://localhost:3000/twirp/subs.Destiny/CommitEvent \
     -H 'content-type: application/json' \
     -d '{"domain": "subs/gifting", "destination": "state://StartGiftStateMachine", "send_at": "2019-02-22T15:00:00Z"}'
```