package destiny

import (
	"context"
)

// Cursor ...
type Cursor string

// URL represents a smaller URL format that `url.URL` parses. This is used
// to avoid storing extra information and having pointers in the fields (which cause extra heap allocations).
type URL struct {
	Scheme string
	Host   string
	Port   int
	Path   string
}

func (u URL) String() string {
	return u.Scheme + "://" + u.Host + u.Path
}

// Destination abstracts out delivering an event to a destination (another service/resource).
type Destination interface {
	// HandleEvent tries to deliver an event and returns typed errors so the event can be retried or not.
	HandleEvent(ctx context.Context, url URL, event Event) (Cursor, error)
}
