package destiny

type retryableErr struct {
	msg string
}

// ErrRetryable constructs a new retryable error.
func ErrRetryable(msg string) error {
	return &retryableErr{
		msg: msg,
	}
}

func (err *retryableErr) Error() string {
	return err.msg
}

func (err *retryableErr) Retryable() bool {
	return true
}

// IsErrRetryable ...
func IsErrRetryable(err error) bool {
	v, ok := err.(interface {
		Retryable() bool
	})

	return ok && v.Retryable()
}

type noRetry struct {
	msg string
}

// ErrNoRetry ...
func ErrNoRetry(msg string) error {
	return &noRetry{
		msg: msg,
	}
}

func (err *noRetry) Error() string {
	return err.msg
}

func (err *noRetry) NoRetry() bool {
	return true
}

// IsErrNoRetry ...
func IsErrNoRetry(err error) bool {
	v, ok := err.(interface {
		NoRetry() bool
	})

	return ok && v.NoRetry()
}
