package destiny

import (
	"context"
	"time"

	"github.com/segmentio/ksuid"
)

// EventDB ...
type EventDB interface {
	WriteEvents(ctx context.Context, events ...Event) error
	ReadEvents(ctx context.Context, offset time.Time, txTimeout time.Duration) EventIter
	Close() error
}

// EventIter ...
type EventIter interface {
	Next(*Event) bool
	Close() error
}

// Event ...
type Event struct {
	ID          ksuid.KSUID
	Domain      string
	Destination string
	Cursor      string
	Encoding    string
	MaxRetries  int
	Payload     []byte
	CreatedAt   time.Time
	Attempts    int
	Commit      func() error
	Retry       func(retryAt time.Time) error
}
