package destiny

import (
	"context"

	"github.com/segmentio/events"
)

type destinationLogger struct {
	base   Destination
	logger *events.Logger
}

func NewDestinationLogger(dest Destination, logger *events.Logger) Destination {
	return &destinationLogger{
		base:   dest,
		logger: logger,
	}
}

func (dest *destinationLogger) HandleEvent(ctx context.Context, url URL, event Event) (cursor Cursor, err error) {
	cursor, err = dest.base.HandleEvent(ctx, url, event)
	if err != nil {
		events.Log("failed to send event: %{error}s => id=%{id}s attempt=%{attempt}d destination=%{url}s", err, event.ID.String(), event.Attempts, url.String())
	} else {
		events.Log("'%{url}s' => successfully sent event to destination=%{destination}s", event.ID.String(), event.Destination)
	}

	return
}
