package sqs

import (
	"context"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sqs"

	destiny "code.justin.tv/danielnf/destiny/internal"
)

type Destination struct {
	client *sqs.SQS
}

func NewDestination(region string) *Destination {
	config := &aws.Config{
		Region: aws.String(region),
	}

	return &Destination{
		client: sqs.New(session.New(config), config),
	}
}

func (dest *Destination) HandleEvent(ctx context.Context, url destiny.URL, event destiny.Event) (cursor destiny.Cursor, err error) {
	input := sqs.SendMessageInput{
		QueueUrl:    aws.String("https://" + url.Host + url.Path),
		MessageBody: aws.String(string(event.Payload)),
	}

	_, err = dest.client.SendMessageWithContext(ctx, &input)
	return
}
