package tests

import (
	"context"
	"io"
	"strconv"
	"testing"
	"time"

	destiny "code.justin.tv/danielnf/destiny/internal"
	"github.com/segmentio/ksuid"
)

func makeEvents(size int, offset time.Time) (events []destiny.Event) {
	events = make([]destiny.Event, size)
	for i := 0; i < size; i++ {
		id, err := ksuid.NewRandomWithTime(offset)
		if err != nil {
			panic(err)
		}

		events[i] = destiny.Event{
			ID:          id,
			Domain:      "testing",
			Destination: "test://foobar",
			Payload:     []byte("some payload"),
		}
	}

	return
}

func BenchEventDB(b *testing.B, makeEventDB MakeEventDB) {
	ctx := context.Background()

	offset := makeTime("2019-01-01T05:05:05Z")
	for i := 10; i < 1000; i *= 2 {
		b.Run(strconv.Itoa(i), func(b *testing.B) {
			events := makeEvents(i, offset)
			db, teardown, err := makeEventDB(ctx, events...)
			if err != nil {
				b.Fatal(err)
			}

			defer teardown()

			b.ResetTimer()
			for i := 0; i < b.N; i++ {
				iter := db.ReadEvents(ctx, offset.Add(time.Second), time.Second)

				var event destiny.Event
				for iter.Next(&event) {
					if err := event.Commit(); err != nil {
						b.Fatal(err)
					}
				}

				if err := iter.Close(); err != io.EOF {
					b.Fatal(err)
				}
			}
		})
	}
}
