package tests

import (
	"encoding/json"
	"fmt"
	"net/http"
	"time"

	"code.justin.tv/danielnf/destiny/destinytwirp"
	vegeta "github.com/tsenart/vegeta/lib"
)

type event struct {
	Domain      string `json:"domain"`
	Destination string `json:"destination"`
	SendAt      string `json:"send_at"`
}

func LoadTestSend(url string, rateN int, duration time.Duration) (err error) {
	header := make(http.Header)
	header.Add("Content-Type", "application/json")

	var reqBody []byte
	reqBody, err = json.Marshal(struct {
		Events []event `json:"events"`
	}{
		Events: []event{
			{
				Domain:      "subs/testing",
				Destination: "local://load-testing",
				SendAt:      time.Now().Add(duration).Format(time.RFC3339),
			},
		},
	})

	if err != nil {
		return
	}

	uri := url + destinytwirp.DestinyPathPrefix + "Send"

	target := vegeta.Target{
		Method: "POST",
		URL:    uri,
		Body:   reqBody,
		Header: header,
	}

	targeter := vegeta.NewStaticTargeter(target)
	attacker := vegeta.NewAttacker()
	metrics := vegeta.Metrics{}
	rate := vegeta.Rate{
		Freq: rateN,
		Per:  time.Second,
	}

	for res := range attacker.Attack(targeter, rate, duration, "Send() Load Test") {
		metrics.Add(res)
	}

	metrics.Close()

	fmt.Printf("metrics: %+v\n", metrics)
	return
}
