resource "aws_rds_cluster" "db" {
  cluster_identifier      = "${var.name}"
  engine                  = "aurora-postgresql"
  engine_version          = "10.5"
  port                    = "5432"
  db_subnet_group_name    = "${aws_db_subnet_group.db.name}"
  database_name           = "destinytwo"
  master_username         = "destinytwo"
  master_password         = "destinytwo"
  skip_final_snapshot     = true
  backup_retention_period = 5
  preferred_backup_window = "07:00-09:00"
  vpc_security_group_ids  = ["${aws_security_group.main.id}", "${var.security_group}"]

  tags {
    Environment = "${var.environment}"
  }
}

resource "aws_db_subnet_group" "db" {
  subnet_ids = ["${split(",",var.subnets)}"]
}

resource "aws_rds_cluster_instance" "instances" {
  count                = "2"
  engine               = "aurora-postgresql"
  engine_version       = "10.5"
  identifier           = "${aws_rds_cluster.db.id}-${count.index}"
  cluster_identifier   = "${aws_rds_cluster.db.id}"
  instance_class       = "db.r4.4xlarge"
  apply_immediately    = true
  db_subnet_group_name = "${aws_db_subnet_group.db.name}"
}

resource "aws_security_group" "main" {
  name        = "${var.name}-rds-cluster"
  description = "Allows traffic to rds from other security groups"
  vpc_id      = "${var.vpc_id}"

  ingress {
    from_port       = "5432"
    to_port         = "5432"
    protocol        = "TCP"
    security_groups = ["${var.security_group}"]
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = -1
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags {
    Name        = "RDS cluster (${var.name})"
    Environment = "${var.environment}"
  }
}
