resource "aws_db_instance" "db" {
  identifier             = "${var.name}"
  allocated_storage      = 3000
  storage_type           = "gp2"
  engine                 = "postgres"
  engine_version         = "10.5"
  instance_class         = "db.r5.12xlarge"
  name                   = "destinytwo"
  username               = "destinytwo"
  password               = "destinytwo"
  parameter_group_name   = "default.postgres10"
  skip_final_snapshot    = true
  apply_immediately      = true
  db_subnet_group_name   = "${aws_db_subnet_group.db.name}"
  vpc_security_group_ids = ["${aws_security_group.main.id}", "${var.security_group}"]
}

resource "aws_db_subnet_group" "db" {
  subnet_ids = ["${split(",",var.subnets)}"]
}

resource "aws_security_group" "main" {
  name        = "${var.name}-rds-cluster"
  description = "Allows traffic to rds from other security groups"
  vpc_id      = "${var.vpc_id}"

  ingress {
    from_port       = "5432"
    to_port         = "5432"
    protocol        = "TCP"
    security_groups = ["${var.security_group}"]
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = -1
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags {
    Name        = "RDS cluster (${var.name})"
    Environment = "${var.environment}"
  }
}
