locals {
  images = {
    production = "522398581884.dkr.ecr.us-west-2.amazonaws.com/danielnf/destiny"
    staging    = "958836777662.dkr.ecr.us-west-2.amazonaws.com/danielnf/destiny"
  }

  counts = {
    production = 1
    staging    = 20
  }

  eventdb = "postgres://destinytwo:destinytwo@${module.eventdb-2.address}/destinytwo"

  subscriptions = {
    staging = "http://subscriptions-stag.internal.justin.tv/twirp/code.justin.tv.revenue.subscriptions.Subscriptions"
  }
}

module "service" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/subs/terracode//service"

  # Chronobreak
  name           = "${lower(var.name)}"
  image          = "${local.images[var.environment]}"
  container_port = 3000
  cpu            = 1024

  min_count = "${local.counts[var.environment]}"
  max_count = 500

  command = [
    "destiny",
    "-datadog-addr=172.17.0.1:8125",
    "-event-db=${local.eventdb}",
    "-environment=${var.environment}",
    "-engine.max-readers=10",
    "-engine.read-interval=1m",
    "-routes.subscriptions=${local.subscriptions[var.environment]}",
  ]

  cluster        = "${var.cluster}"
  security_group = "${var.security_group}"
  region         = "${var.region}"
  vpc_id         = "${var.vpc_id}"
  environment    = "${var.environment}"
  subnets        = "${var.subnets}"
}
