execute'Enable EPEL' do
  command 'sudo amazon-linux-extras install epel -y'
end

package 'curl'
package 'nfs-utils'
package 'amazon-efs-utils'

execute 'setup nodejs' do
  command 'sudo curl -sL https://rpm.nodesource.com/setup_14.x | sudo bash -'
end

execute 'update yum' do
  command 'sudo yum -y update'
end

package 'nodejs'
package 'nginx'

directory '/mnt/web' do
  owner 'root'
  group 'root'
  mode '0755'
  action :create
end

cookbook_file "Copy fstab" do
  group "root"
  mode "0440"
  owner "root"
  path "/etc/fstab"
  source "fstab"
end

execute'Mount' do
  command 'sudo mount -a'
end
