package 'freeradius'
package 'freeradius-ldap'
package 'freeradius-utils'

cookbook_file "Copy FreeRADIUS Dictionary" do
  group "radiusd"
  mode "0440"
  owner "root"
  path "/etc/raddb/dictionary"
  source "dictionary"
end

cookbook_file "Copy FreeRADIUS proxy.conf" do
  group "radiusd"
  mode "0640"
  owner "root"
  path "/etc/raddb/proxy.conf"
  source "proxy.conf"
end

cookbook_file "Copy FreeRADIUS proxyhomeservers.conf" do
  group "radiusd"
  mode "0440"
  owner "root"
  path "/etc/raddb/proxyhomeservers.conf"
  source "proxyhomeservers.conf"
end

cookbook_file "Copy FreeRADIUS clients.conf" do
  group "radiusd"
  mode "0440"
  owner "root"
  path "/etc/raddb/clients.conf"
  source "clients.conf"
end

cookbook_file "Copy FreeRADIUS ldap" do
  group "radiusd"
  mode "0440"
  owner "root"
  path "/etc/raddb/mods-available/ldap"
  source "ldap"
end

cookbook_file "Copy FreeRADIUS ldap" do
  group "radiusd"
  mode "0440"
  owner "root"
  path "/etc/raddb/sites-available/default"
  source "default"
end

cookbook_file "Copy Intermediate CA" do
  group "radiusd"
  mode "0440"
  owner "root"
  path "/etc/raddb/certs/amazon-rootca1.pem"
  source "amazon-rootca1.pem"
end

link 'Enable LDAP FreeRADIUS Module' do
  to '/etc/raddb/mods-available/ldap'
  target_file '/etc/raddb/mods-enabled/ldap'
  group 'radiusd'
  owner 'root'
end

service 'radiusd' do
  action [ :enable, :start, :restart]
end
