package 'tftp-server'
package 'xinetd'

#execute 'Disable SELinux' do
#  command 'setenforce 0'
#end

execute 'Install nginx' do
  command 'amazon-linux-extras install -y nginx1'
end

service 'Enable & Start/Restart tftp' do
  service_name 'tftp'
  action [ :enable, :start, :restart]
end

cookbook_file "Copy undionly.kpxe file" do
  source "dco.kpxe"
  path "/var/lib/tftpboot/dco.kpxe"
  group "root"
  mode "0644"
  owner "root"
  action :create
end

cookbook_file "Copy Kernel" do
  path '/usr/share/nginx/html/vmlinuz'
  group "root"
  mode "0644"
  owner "root"
  source "vmlinuz"
end

cookbook_file "Copy initramfs" do
  path '/usr/share/nginx/html/initramfs.img'
  group "root"
  mode "0644"
  owner "root"
  source "initramfs.img"
end

directory '/var/lib/tftpboot/menu/' do
  action :create
end

cookbook_file "Copy default ipxe file" do
  group "root"
  mode "0644"
  owner "root"
  path "/var/lib/tftpboot/menu/boot.ipxe"
  source "boot.ipxe"
end

file 'Delete default nginx html file'	do
  path '/usr/share/nginx/html/index.html'	
  action :delete	
end	

service 'Enable & Start/Restart nginx Server' do	
  service_name 'nginx'	
  action [ :enable, :start, :restart]	
end
